<?php
/**
 * Plugin name: My Snow Monkey
 * Description: このプラグインに、あなたの Snow Monkey 用カスタマイズコードを書いてください。
 * Version: 0.2.1
 *
 * @package my-snow-monkey
 * @author inc2734
 * @license GPL-2.0+
 */

/**
 * Snow Monkey 以外のテーマを利用している場合は有効化してもカスタマイズが反映されないようにする
 */
$theme = wp_get_theme( get_template() );
if ( 'snow-monkey' !== $theme->template && 'snow-monkey/resources' !== $theme->template ) {
	return;
}

/**
 * Directory url of this plugin
 *
 * @var string
 */
define( 'MY_SNOW_MONKEY_URL', untrailingslashit( plugin_dir_url( __FILE__ ) ) );

/**
 * Directory path of this plugin
 *
 * @var string
 */
define( 'MY_SNOW_MONKEY_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );


// 実際のページ用の CSS 読み込み
add_action(
	'wp_enqueue_scripts',
	function() {
		wp_enqueue_style(
			'my-snow-monkey',
			MY_SNOW_MONKEY_URL . '/style.css',
			[ Framework\Helper::get_main_style_handle() ],
			filemtime( MY_SNOW_MONKEY_PATH . '/style.css' )
		);
	}
);

// エディター用の CSS 読み込み
// クラシックエディターとブロックエディターの両方に CSS が読み込まれます。
// ブロックエディターの場合は自動的に .editor-styles-wrapper でラップされます。
// 依存関係は指定できません。
add_action(
	'after_setup_theme',
	function() {
		add_theme_support( 'editor-styles' );
		add_editor_style( '/../../plugins/my-snow-monkey/style.css' );
	}
);
add_action(
	'wp_enqueue_scripts',
	function() {
		wp_enqueue_script(
			'effect-fade',
			'/wp-content/plugins/my-snow-monkey/calc.js',
			[],
			false
		);
	}
);
// headerに独自のタグを追加する
// Google fontsの読み込み
add_action( 'wp_head', function() {
	?>
		<script src="https://code.jquery.com/jquery-3.4.1.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery-rwdImageMaps/1.6/jquery.rwdImageMaps.min.js"></script>
		<script src="https://ridewave.co.jp/posting_lp/wp-content/plugins/my-snow-monkey/js/javascript.js" charset="UTF-8"></script>
	<?php
	}
);


// ショートコードを登録
add_shortcode( 'hsm-shorcode-demo-name', 'hsm_shortcode_function_name' );


/*管理画面に再利用ブロックを追加する*/
add_action( 'admin_menu', 'add_custom_menu' );
function add_custom_menu(){
    add_menu_page( '再利用ブロックの管理', '再利用ブロックの管理',
    'manage_options', 'edit.php?post_type=wp_block', '', 'dashicons-admin-post', 21 ); 
}


add_action(
	'wp_body_open',
	function() {
		?>
<div id="kotei-br">

</div>
<div id="kotei-br-sp">

</div>
		<?php
	}
);